// PCXF.H - header for PCX graphic functions
#ifndef PCXF_H
#define PCXF_H

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~GLOBALS~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//transparent colour for sprites.
const char CLEAR = 0;
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~INCLUDES~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#include <stdio.h>
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~STRUCTURES~~~~~~~~~~~~~~~~~~~~~~~~~
struct bit24 {
   char b;
   char g;
   char r;
   bit24() {}
   bit24(int c) { r = c >> 16; g = c >> 8; b = c; }
};

struct pcx {
   int x;
   int y;
   unsigned char *d;
   int *d32;
};


//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~REFERENCE~~~~~~~~~~~~~~~~~~~~~~~~~
#define RGB16BIT555(r, g, b) ((b & 31) + ((g & 31) << 5) + ((r & 31) << 10))
#define RGB16BIT565(r, g, b) ((b & 31) + ((g & 63) << 5) + ((r & 31) << 11))
#define RGB24BIT(r, g, b) ((b) + ((g) << 8) + ((r) << 16))
#define RGB32BIT(r, g, b, a) ((b) + ((g) << 8) + ((r) << 16) + ((a) << 24))

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~PROTOTYPES~~~~~~~~~~~~~~~~~~~~~~~~~

char readChar(FILE *fileo);
int readInt(FILE *fileo);
long readLong(FILE *fileo);
//void pcxInfo(char pic[12]);

inline void pixel8(int x, int y, char colour);
inline void pixel16(int x, int y, short colour);
inline void pixel24(int x, int y, bit24 colour);
inline void pixel32(int x, int y, long colour);

void pcxStore(char pic[12], pcx *store); //remember to 'delete store.d' when done with memory pcx.

void pcxStoreArray(char pic[12], pcx **store, int number, int sizeX, int sizeY); //used to load fonts.
void pcxRestore(pcx *store, int angle, pcx *newstore);
void pcxDisplay(int x, int y, pcx *store, int overrideColour);
void pcxAngleDisplay(int x, int y, pcx *store, int angle, int overrideColour);

void drawOn(pcx *store);

extern "C" {
   inline void pixel(int x, int y, int colour);
   int colour(unsigned char r, unsigned char g, unsigned char b);
   void setScreen(void *pixels, int width, int height, int depth);
   void setScreenGL(void (*pixels)(int, int, int), int width, int height, int depth);
   void loadFonts(void);
   void unloadFonts(void);
   void writeInt(int x, int y, int num, int colour);
   void writeString(int x, int y, char *text, int colour);
   void writeDouble(int x, int y, double num, int colour);

   void line(int x1, int y1, int x2, int y2, int colour);
   void rectangle(int x1, int y1, int x2, int y2, int colour);
   int *getPalette(char pal[12]); //SDL_SetPalette(screen, SDL_LOGPAL|SDL_PHYSPAL, (SDL_Color *) getPalette("palette.gpl"), 0, 256);

   void pcxStore32(char pic[12], pcx *store);
   void pcxDisplay32(int x, int y, pcx *store, int overrideColour);
   void pcxRestore32(pcx *store, int angle, pcx *newstore);
}

//possible calling conventions:
//__cdecl //caller cleans up stack
//__stdcall //callie cleans up stack
//__fastcall //arguments passed by registers
//void __cdecl setScreen(void *pixels, int width, int height, int depth); //vc++ windows/borland
//void setScreen(void *pixels, int width, int height, int depth) __attribute__((stdcall)); //gcc

#endif
